
%% Filenames
prefix1 = 'E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\Field Spectra\';
% cd('E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\Field Spectra\');
savedmats2 = {...
	'6A 4-28 2016 - 1830 - 0430 cleaned_smooth.mat';...
	'11A 5-5 2016 - 0800-2100 - Stg7 cleaned_smooth.mat';
	'11A 5-5 2016 - 0800-2100 - Stg8 cleaned_smooth.mat';
	'thief_tar.mat';...
	'17A 5-14 2016 - 1100-1515 - Stg7 cleaned_smooth.mat';
	'thief_ambientasop.mat'};

for i = 1:length(savedmats2)
savedmats2{i} = [prefix1,savedmats2{i}];
end

savedmats2{end+1} = 'E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\SavedSpectra\ASOP_Bubbling_Clean_smooth_cal.mat';
% savedmats2{end+1} = 'E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\SavedSpectra\ASOP_Nebulizing_Clean_smooth_cal.mat';

%% Looping over each .mat file
for matidx = 1:length(savedmats2)
	load(savedmats2{matidx})
	
	if exist('newspecmat','var')
		currspecmat = newspecmat;
	elseif matidx == 6
		currspecmat = BackgroundFit_STXM(ambasop_int,ambasop_energy);
		energy = ambasop_energy;
	elseif matidx == 4
		currspecmat = BackgroundFit_STXM(tar_int,tar_energy);
		energy = tar_energy;
	else
		currspecmat = normspecmat;
	end
	
	for specidx = 1:size(currspecmat,1)
		currspec = currspecmat(specidx,:);
		
		%% COOH peak at 288.6 eV
		peak_cooh = findpeaks(currspec(energy >= 288.1 & energy <= 289.1));
		if isempty(peak_cooh) %if no peaks found, take abs at literature energy value
			[~,eval_cooh] = min(abs(energy - 288.6));
			peak_cooh = currspec(eval_cooh);
		elseif numel(peak_cooh) > 1 %in case a vector is returned, take the max
			peak_cooh = max(peak_cooh);
		end
		
		%% COH peak at 286.7 eV
		peak_coh = findpeaks(currspec(energy >= 286.2 & energy <= 287.2));
		if isempty(peak_coh) %if no peaks found, take abs at literature energy value
			[~,eval_coh] = min(abs(energy - 286.7));
			peak_coh = currspec(eval_coh);
		elseif numel(peak_coh) > 1 %in case a vector is returned, take the max
			peak_coh = max(peak_coh);
		end
		
		%% C=C peak at 285.3 eV
		peak_cc = findpeaks(currspec(energy >= 284.8 & energy <= 285.8));		
		if isempty(peak_cc) %if no peaks found, take abs at literature energy value
			[~,eval_cc] = min(abs(energy - 285.3));
			peak_cc = currspec(eval_cc);
		elseif numel(peak_cc) > 1 %in case a vector is returned, take the max
			peak_cc = max(peak_cc);
		end
		
		%% Peak Ratios
		cooh_cc_ratio{matidx}(1,specidx) = peak_cooh ./ peak_cc;
		cooh_coh_ratio{matidx}(1,specidx) = peak_cooh ./ peak_coh;
		
	end
	
	cooh_cc_mean(matidx) = mean(cooh_cc_ratio{matidx});
	cooh_coh_mean(matidx) = mean(cooh_coh_ratio{matidx});
	cooh_cc_stderr(matidx) = std(cooh_cc_ratio{matidx}) .* tinv(0.975,size(currspecmat,1)) ./ sqrt(size(currspecmat,1));
	cooh_coh_stderr(matidx) = std(cooh_coh_ratio{matidx}) .* tinv(0.975,size(currspecmat,1)) ./ sqrt(size(currspecmat,1));
	
	clear newspecmat normspecmat energy
end

%% Using ensemble data
% xvals = 1:length(savedmats2);
% figure; hold on;
% plot(xvals,cooh_cc_mean,'LineStyle','none','Marker','.','MarkerSize',45,'Color','b');
% plot(xvals,cooh_coh_mean,'LineStyle','none','Marker','.','MarkerSize',45,'Color','r');
% 
% plot(xvals,(cooh_cc_mean + cooh_cc_stderr),'LineStyle','none','Marker','.','MarkerSize',20,'Color','b');
% plot(xvals,(cooh_coh_mean + cooh_coh_stderr),'LineStyle','none','Marker','.','MarkerSize',20,'Color','r');
% 
% plot(xvals,(cooh_cc_mean - cooh_cc_stderr),'LineStyle','none','Marker','.','MarkerSize',20,'Color','b');
% plot(xvals,(cooh_coh_mean - cooh_coh_stderr),'LineStyle','none','Marker','.','MarkerSize',20,'Color','r');
% 
% xlim([0,8]);
% ylim([0,4]);
% set(gca,'XTick',[1,2,3,4,5,6,7,8]);
% % set(gca,'XTickLabel',{'28-Apr','5-May s7','5-May s8','14-May','ASOPs','Tar Balls','Bubbling','Nebulizing'});
% set(gca,'XTickLabel',{'28-Apr','5-May s7','5-May s8','Tar Balls','14-May','ASOPs','Bubbling','Nebulizing'});
% set(gca,'XTickLabelRotation',45);
% set(gca,'FontWeight','bold','FontSize',30);
% axis square
% set(gca,'YTick',[0,1,2,3,4]);
% set(gca,'Color','none');
% ylabel('Peak Ratio');

%% Using ErrorBar plot
xvals = 1:length(savedmats2);
figure; hold on;
errorbar(xvals,cooh_cc_mean,cooh_cc_stderr,'LineWidth',2,'LineStyle','none','Marker','.','MarkerSize',45);
errorbar(xvals,cooh_coh_mean,cooh_coh_stderr,'LineWidth',2,'LineStyle','none','Marker','.','MarkerSize',45);
% plot(xvals,cooh_cc_mean,'LineStyle','none','Marker','.','MarkerSize',45,'Color','b');
% plot(xvals,cooh_coh_mean,'LineStyle','none','Marker','.','MarkerSize',45,'Color','r');
xlim([0,8]);
ylim([0,5.1]);
set(gca,'XTick',[1,2,3,4,5,6,7]);
% set(gca,'XTickLabel',{'28-Apr','5-May s7','5-May s8','14-May','ASOPs','Tar Balls','Bubbling','Nebulizing'});
set(gca,'XTickLabel',{'28-Apr','5-May s7','5-May s8','Tar Balls','14-May','ASOPs','ASOP Proxies'});
set(gca,'XTickLabelRotation',45);
set(gca,'FontWeight','bold','FontSize',30);
axis square
legend({'COOH/C=C','COOH/COH'},'box','on');
% set(gca,'YTick',[0,1,2,3,4]);
set(gca,'Color','none');
ylabel('Peak Ratio');




%% Values Picked from Plots
% ccratio = [2.33, 2.3, 2.96, 1.73, 1.93, 3.83, 5.14, 2.04];
% ccerr = [0.3408, 0.2398, 1.077, 0.607, 0, 0, 0, 0.9257];
% cohratio = [1.82, 1.77, 2.22, 1.83, 1.78, 2.7, 2.41, 1.8];
% coherr = [0.2347, 0.2579, 0.4638, 0.3602, 0, 0, 0, 0.7577];
% ccratio(7) = [];
% ccerr(7) = [];
% cohratio(7) = [];
% coherr(7) = [];
% xvals = 1:7;
% figure; hold on;
% % plot(xvals,ccratio,'LineStyle','none','Marker','.','MarkerSize',45);
% % plot(xvals,cohratio,'LineStyle','none','Marker','.','MarkerSize',45);
% errorbar(xvals,ccratio,ccerr,'LineStyle','none','Marker','.','MarkerSize',45);
% errorbar(xvals,cohratio,coherr,'LineStyle','none','Marker','.','MarkerSize',45);
% xlim([0,8]);
% ylim([0,4]);
% set(gca,'XTick',[1,2,3,4,5,6,7]);
% set(gca,'XTickLabel',{'28-Apr','5-May s7','5-May s8','14-May','ASOPs','Tar Balls','Bubbling'});
% set(gca,'XTickLabelRotation',45);
% set(gca,'FontWeight','bold','FontSize',30);
% legend({'COOH/C=C','COOH/COH'});
% legend({'COOH/C=C','COOH/COH'},'box','off');
% legend({'COOH/C=C','COOH/COH'});
% legend({'COOH/C=C','COOH/COH'},'box','on');
% axis square
% set(gca,'YTick',[0,1,2,3,4]);
% set(gca,'Color','none');
% ylabel('Peak Ratio');